#!/bin/sh
#
# This script removes the unified NVidia driver.  It basically boils down to
# three commands; you could just as easily run them by hand.
#
# Bugs:
#	This script is not terribly robust.  Try not to stress it; 'bash'
#	isn't my first language.
#
# Leo L. Schwab						2000.09.30
#

ask() {
  until
    echo -n "$1"
    if ! read
    then
      echo EOF
      exit 1
    fi
    case $REPLY in 
      y|yes|n|no) true ;;
      *) false;;
    esac
  do
  echo please answer yes or no
  done
  case $REPLY in n|no) return 1 ;; esac
  return 0
}


# This doesn't seem to actually work...
if echo $_ | grep Tracker
then
	# if invoked from tracker
	export INWINDOW=1
	Terminal -t "Unified NVidia Driver Removal" $0
	exit 0
fi

ADD_ONS="/system/add-ons"
DRIVERDIR="/system/add-ons/kernel/drivers/bin"
# (only the old rivatnt for now.  riva128 will be added later when it's
# working)
OLDDRIVERS="rivatnt"
DEV="nvidia"


echo "Remove Experimental Unified NVidia Graphics Driver"
echo "--------------------------------------------------"
echo
echo "This script will remove the experimental unified driver for NVidia-based"
echo "graphics cards."
echo
echo "This script will *DELETE* the NVidia-related files in your /system"
echo "directory, and restore the old R5 RIVA TNT driver.  If you wish to"
echo "re-install later, you will need to locate and use the files you"
echo "originally used to install the driver."
echo

if ! ask "Do you wish to DELETE the NVidia driver? "
then
	exit 0
fi


echo
echo "Deleting NVidia driver files..."
rm -f $ADD_ONS/kernel/drivers/dev/graphics/$DEV
rm -f $ADD_ONS/kernel/drivers/bin/$DEV
rm -f $ADD_ONS/accelerants/$DEV.accelerant

echo "Restoring old R5 RIVA drivers:"
for drv in $OLDDRIVERS; do
	if [ -e $DRIVERDIR/$drv-disabled ]; then
		echo "...$drv"
		mv $DRIVERDIR/$drv-disabled $DRIVERDIR/$drv
	fi
done
echo "Done."

echo
echo "Removal completed."
echo


if [ "$INWINDOW" != "" ]
then
	echo -n "(Press Enter to close this window.) "
	read
fi
